// XISLTag.cpp: CXISLTag NX̃Cve[V
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "ib.h"
#include "XISLTag.h"


#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif


//////////////////////////////////////////////////////////////////////
// \z/
//////////////////////////////////////////////////////////////////////

CXISLTag::CXISLTag()
{
	m_strXISL = "";
	m_pParentTag = NULL;
	m_nBmpID = IDB_NOTFOUND;
	m_rectBMP = CRect(0,0,0,0);
}

CXISLTag::~CXISLTag()
{
	m_pParentTag = NULL;
}

CXISLTag::CXISLTag(const CXISLTag &cpXISL)
{
	m_nTagType = cpXISL.m_nTagType;
	m_strXISL = cpXISL.m_strXISL;
	m_htreeItem = cpXISL.m_htreeItem;
	m_pParentTag = cpXISL.m_pParentTag;
	m_rectBMP = cpXISL.m_rectBMP;
	m_nBmpID = cpXISL.m_nBmpID;
}

CXISLTag& CXISLTag::operator=(const CXISLTag &cpXISL)
{
	if(&cpXISL != this)
	{
		m_nTagType = cpXISL.m_nTagType;
		m_strXISL = cpXISL.m_strXISL;
		m_htreeItem = cpXISL.m_htreeItem;
		m_pParentTag = cpXISL.m_pParentTag;
		m_rectBMP = cpXISL.m_rectBMP;
		m_nBmpID = cpXISL.m_nBmpID;
	}
	return *this;
}

LPCTSTR CXISLTag::GetXISLString()
{
	return (LPCTSTR)m_strXISL;
}

//BMP̕\ʒuݒ
void CXISLTag::SetRectBMP(int nLeft,int nTop,int nWidth,int nHeight)
{
	m_rectBMP.left = nLeft;
	m_rectBMP.top = nTop;
	m_rectBMP.right = nLeft + nWidth;
	m_rectBMP.bottom = nTop + nHeight;
}

//BMP̕\ʒuԂ
void CXISLTag::GetRectBMP(LPRECT lpRect)
{
	::CopyRect(lpRect,&m_rectBMP);
}

//w肵|CgɎBMP\Ă邩H
CXISLTag* CXISLTag::FindTag(POINT point,BOOL bOnly)
{
	m_rectBMP.NormalizeRect();
	if(m_rectBMP.PtInRect(point))
		return this;
	else
		return NULL;
}

//Ăexchange^Õ|C^Ԃ
CXISLTag* CXISLTag::GetParentExcTag()
{
	CXISLTag *pTag = this;
	while(pTag->m_nTagType != ID_TAG_XISL)
	{
		if(pTag->m_nTagType == ID_TAG_EXCHANGE
			|| pTag->m_nTagType == ID_TAG_BEGIN
			|| pTag->m_nTagType == ID_TAG_END)
			return pTag;
		pTag = pTag->m_pParentTag;
	}

	return NULL;
}

//Ădialog^Õ|C^Ԃ
CXISLTag* CXISLTag::GetParentDialogTag()
{
	CXISLTag *pTag = this;
	while(pTag->m_nTagType != ID_TAG_XISL)
	{
		if(pTag->m_nTagType == ID_TAG_DIALOG)
			return pTag;
		pTag = pTag->m_pParentTag;
	}

	return NULL;
}

//Ăroot^Õ|C^Ԃ
CXISLTag* CXISLTag::GetRootTag()
{
	CXISLTag *pTag = m_pParentTag;
	while(pTag)
	{
		if(pTag->m_nTagType == ID_TAG_XISL)
			return pTag;
		pTag = pTag->m_pParentTag;
	}
	if(m_nTagType == ID_TAG_XISL)
		return this;

	return NULL;
}
